/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageEventType;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractAttributeStorage
implements Iterable<MRIValueEvent> {
    private final List<IAttributeStorageListener> m_storageListeners = new ArrayList<IAttributeStorageListener>();
    private final IMRIValueListener m_attributeValueListener = this.createAttributeValueListener();

    private IMRIValueListener createAttributeValueListener() {
        return new IMRIValueListener(){

            @Override
            public void valueChanged(MRIValueEvent event) {
                AbstractAttributeStorage.this.storeEvent(event);
                AbstractAttributeStorage.this.fireStorageEvent(AttributeStorageEventType.ADDED, event);
            }
        };
    }

    IMRIValueListener getAttributeValueListener() {
        return this.m_attributeValueListener;
    }

    protected abstract void storeEvent(MRIValueEvent var1);

    public abstract Iterator<MRIValueEvent> iterator(long var1, long var3);

    public abstract void dispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStorageListener(IAttributeStorageListener listener) {
        List<IAttributeStorageListener> list = this.m_storageListeners;
        synchronized (list) {
            this.m_storageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStorageListener(IAttributeStorageListener listener) {
        List<IAttributeStorageListener> list = this.m_storageListeners;
        synchronized (list) {
            this.m_storageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStorageEvent(AttributeStorageEventType type, MRIValueEvent event) {
        IAttributeStorageListener[] listeners;
        List<IAttributeStorageListener> list = this.m_storageListeners;
        synchronized (list) {
            listeners = this.m_storageListeners.toArray(new IAttributeStorageListener[this.m_storageListeners.size()]);
        }
        IAttributeStorageListener[] iAttributeStorageListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeStorageListener listener = iAttributeStorageListenerArray[n2];
            listener.storageUpdated(type, event);
            ++n2;
        }
    }
}

